package jamezo97.clonecraft.item;

import jamezo97.clonecraft.dna.Gene;

import java.util.HashMap;
import java.util.List;

import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class ItemGene extends Item{

	public ItemGene(int par1) {
		super(par1);
		this.setHasSubtypes(true);
	}



	@Override
	public int getColorFromItemStack(ItemStack stack, int par2) {
		int meta = stack.getItemDamage();
		Gene g = Gene.getGene(meta);
		if(g != null){
			return g.getColour();
		}
		return 0;
	}

	HashMap<Integer, Integer> metaToIcon = new HashMap<Integer, Integer>(); 

	int currIcon = 0;

	public Icon getIconFromDamage(int meta){
		if(metaToIcon.containsKey(meta)){
			return icons[metaToIcon.get(meta)];
		}
		int next = currIcon;
		currIcon++;
		if(currIcon >= icons.length){
			currIcon = 0;
		}
		metaToIcon.put(meta, next);
		return icons[next];
	}
	


	@Override
	public boolean hitEntity(ItemStack par1ItemStack, EntityLivingBase hit, EntityLivingBase from) {
		if(!hit.worldObj.isRemote && hit instanceof EntityLiving){
			Gene gene = Gene.getGene(par1ItemStack.getItemDamage());
			if(gene != null){
				gene.mutateLivingEntity((EntityLiving)hit, gene.getMaxAmount());
				return true;
			}
		}
		return true;
	}
	
	



	@Override
	public String getItemDisplayName(ItemStack stack) {
		int meta = stack.getItemDamage();
		Gene gene = Gene.getGene(meta);
		if(gene != null){
			return gene.getName() + " Gene";
		}
		return "Unknown Gene";
	}


	Icon[] icons;
	@Override
	public void registerIcons(IconRegister ir) {
		this.itemIcon = ir.registerIcon("CloneCraft:gene0");
		icons = new Icon[7];
		icons[0] = itemIcon;
		icons[1] = ir.registerIcon("CloneCraft:gene1");
		icons[2] = ir.registerIcon("CloneCraft:gene2");
		icons[3] = ir.registerIcon("CloneCraft:gene3");
		icons[4] = ir.registerIcon("CloneCraft:gene4");
		icons[5] = ir.registerIcon("CloneCraft:gene5");
		icons[6] = ir.registerIcon("CloneCraft:gene6");
	}



	@Override
	public boolean getHasSubtypes() {
		return super.getHasSubtypes();
	}



	@Override
	public void getSubItems(int par1, CreativeTabs par2CreativeTabs, List par3List) {
		int[] ids = Gene.getAllGeneIds();
		for(int a = 0; a < ids.length; a++){
			int id = ids[a];
			//			Gene gene = Gene.getGene(id);
			ItemStack toAdd = new ItemStack(this.itemID, 1, ids[a]);
			par3List.add(toAdd);
		}
	}






}
